package game;


import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;

public class CustomImageData {
	
	Image myImage;
	int myDesiredWidth;
	int myDesiredHeight;
	
	ImageObserver myObserver;
	
	Color myTransparentColor = null;
	
	String message = null;
	
	boolean hasBeenInitialized = false;
	
	public CustomImageData(Image theImage, int desiredWidth, int desiredHeight, Color transparentColor, ImageObserver obs) {
		if(transparentColor == null)
			myImage = theImage;
		else
			myImage = makeColorTransparent(theImage, transparentColor, obs, desiredWidth, desiredHeight);
		myDesiredWidth = desiredWidth;
		myDesiredHeight = desiredHeight;
		
		myObserver = obs;
		
		myTransparentColor = transparentColor;
	}
	
	private static GraphicsConfiguration gc = null;
	
	private static synchronized GraphicsConfiguration getGC() {
		
		if(gc == null) {
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
		}
		
		return gc;
		
	}
	
	
	
	/**
	 * the below method is from http://www.rgagnon.com/javadetails/java-0265.html,
	 * written by Real Gagnon---whoever that is.  Almost sounds like the kind of
	 * name you'd see in a Zelda game...meh w/e.
	 * 
	 * 
	 * @param im
	 * @param color
	 * @return
	 */
	
	public static Image makeColorTransparent(Image im, final Color color, ImageObserver io, int width, int height) {
		if(color == null || im == null)
			return im;
		
	    ImageFilter filter = new RGBImageFilter() {
	      // the color we are looking for... Alpha bits are set to opaque
	      public int markerRGB = color.getRGB() | 0xFF000000;
	
	      public final int filterRGB(int x, int y, int rgb) {
	        if ( ( rgb | 0xFF000000 ) == markerRGB ) {
	          // Mark the alpha bits as zero - transparent
	          return 0x00FFFFFF & rgb;
	          }
	        else {
	          // nothing to do
	          return rgb;
	          }
	        }
	      }; 
	
	    ImageProducer ip = new FilteredImageSource(im.getSource(), filter);
	    Image rawImage = Toolkit.getDefaultToolkit().createImage(ip);
	    
//	    BufferedImage returnValue = getGC().createCompatibleImage(width, height);
//	    
//	    Graphics2D g = returnValue.createGraphics();
//	    g.drawImage(rawImage, 0, 0, width, height, io);
//	    g.dispose();
	    
	    return rawImage;
	    
    }
	
	
	public static Image makeColorTransparentOld(Image im, final Color color) {
		if(color == null || im == null)
			return im;
		
	    ImageFilter filter = new RGBImageFilter() {
	      // the color we are looking for... Alpha bits are set to opaque
	      public int markerRGB = color.getRGB() | 0xFF000000;
	
	      public final int filterRGB(int x, int y, int rgb) {
	        if ( ( rgb | 0xFF000000 ) == markerRGB ) {
	          // Mark the alpha bits as zero - transparent
	          return 0x00FFFFFF & rgb;
	          }
	        else {
	          // nothing to do
	          return rgb;
	          }
	        }
	      }; 
	
	    ImageProducer ip = new FilteredImageSource(im.getSource(), filter);
	    return Toolkit.getDefaultToolkit().createImage(ip);
    }
	
	
	public static Image makeImageMoreTransparentOfTen(Image im, final int outOfTen) {
	    ImageFilter filter = new RGBImageFilter() {
	      // the color we are looking for... Alpha bits are set to opaque
	      public final int filterRGB(int x, int y, int rgb) {
	    	  
	    	  Color clr = new Color(rgb);
	    	  
	    	  int red = clr.getRed();
	    	  int green = clr.getGreen();
	    	  int blue = clr.getBlue();
	    	  int alpha = clr.getAlpha();
	    	  
	    	  Color returnValue = new Color(red, green, blue, alpha * outOfTen / 10);
	    	  return returnValue.getRGB();
	        }
	      }; 
	
	    ImageProducer ip = new FilteredImageSource(im.getSource(), filter);
	    return Toolkit.getDefaultToolkit().createImage(ip);
    }
	
	public static Image makeImageMoreTransparentOfEight(Image im, final int outOfEight) {
	    ImageFilter filter = new RGBImageFilter() {
	      // the color we are looking for... Alpha bits are set to opaque
	      public final int filterRGB(int x, int y, int rgb) {
	    	  
	    	  Color clr = new Color(rgb);
	    	  
	    	  int red = clr.getRed();
	    	  int green = clr.getGreen();
	    	  int blue = clr.getBlue();
	    	  int alpha = clr.getAlpha();
	    	  
	    	  Color returnValue = new Color(red, green, blue, alpha * outOfEight / 8);
	    	  return returnValue.getRGB();
	        }
	      }; 
	
	    ImageProducer ip = new FilteredImageSource(im.getSource(), filter);
	    return Toolkit.getDefaultToolkit().createImage(ip);
    }
	
	public static Image makeImageMoreTransparentOfX(Image im, final int dividend, final int divisor) {
	    ImageFilter filter = new RGBImageFilter() {
	      // the color we are looking for... Alpha bits are set to opaque
	      public final int filterRGB(int x, int y, int rgb) {
	    	  
	    	  Color clr = new Color(rgb);
	    	  
	    	  int red = clr.getRed();
	    	  int green = clr.getGreen();
	    	  int blue = clr.getBlue();
	    	  int alpha = clr.getAlpha();
	    	  
	    	  Color returnValue = new Color(red, green, blue, alpha * dividend / divisor);
	    	  return returnValue.getRGB();
	        }
	      }; 
	
	    ImageProducer ip = new FilteredImageSource(im.getSource(), filter);
	    return Toolkit.getDefaultToolkit().createImage(ip);
    }
	
	public static Image makeImageMoreTransparentOfThirtySeven(Image im, final int outOfThirtySeven) {
	    ImageFilter filter = new RGBImageFilter() {
	      // the color we are looking for... Alpha bits are set to opaque
	      public final int filterRGB(int x, int y, int rgb) {
	    	  
	    	  Color clr = new Color(rgb);
	    	  
	    	  int red = clr.getRed();
	    	  int green = clr.getGreen();
	    	  int blue = clr.getBlue();
	    	  int alpha = clr.getAlpha();
	    	  
	    	  Color returnValue = new Color(red, green, blue, alpha * outOfThirtySeven / 37);
	    	  return returnValue.getRGB();
	        }
	      }; 
	
	    ImageProducer ip = new FilteredImageSource(im.getSource(), filter);
	    return Toolkit.getDefaultToolkit().createImage(ip);
    }
	
	public static Image makeImageMoreTransparentOf255(Image im, final int outOf255) {
		
//		System.out.println("<><>DELME about to return the given image, which is stupid; get rid of this code soon!");
//		if(0 == 0)
//			return im;
		
		
	    ImageFilter filter = new RGBImageFilter() {
	      // the color we are looking for... Alpha bits are set to opaque
	      public final int filterRGB(int x, int y, int rgb) {
	    	  
	    	  Color clr = new Color(rgb);
	    	  
	    	  int red = clr.getRed();
	    	  int green = clr.getGreen();
	    	  int blue = clr.getBlue();
	    	  int alpha = clr.getAlpha();
	    	  
	    	  Color returnValue = new Color(red, green, blue, alpha * outOf255 / 255);
	    	  return returnValue.getRGB();
	        }
	      }; 
	
	    ImageProducer ip = new FilteredImageSource(im.getSource(), filter);
	    return Toolkit.getDefaultToolkit().createImage(ip);
    }

	public CustomImageData[] retrieveSetOfFading() {
		
		CustomImageData returnValue[] = new CustomImageData[11];
		
		Color adjustedTransparentColor = null;
		
		for(int i = 10; i >= 0; i--) {
			
			adjustedTransparentColor = new Color(myTransparentColor.getRed(), myTransparentColor.getGreen(), myTransparentColor.getBlue(), myTransparentColor.getAlpha() * i / 10);
			
			returnValue[10 - i] = new CustomImageData(
					makeImageMoreTransparentOfTen(this.getImage(),i),
					this.getDesiredWidth(),
					this.getDesiredHeight(),
					adjustedTransparentColor,
					this.getObserver()
					);
			
			returnValue[10 - i].setMessage("this is faded item number " + (10 - i));
			
		}
		
		
		return returnValue;
		
	}
	
	


	public int getDesiredHeight() {
		return myDesiredHeight;
	}


	public int getDesiredWidth() {
		return myDesiredWidth;
	}


	public Image getImage() {
		return myImage;
	}


	public ImageObserver getObserver() {
		return myObserver;
	}
	
	public void drawObject(Graphics g, int x, int y) {
		
//		if(message != null)
//			System.out.println("now in drawObject; is my image null?  " + (myImage == null) + ", transparent color alpha: " + myTransparentColor.getAlpha() + ", x: " + myDesiredWidth + ", y: " + myDesiredHeight + ", message: " + message);
		
//		if(myImage == null) {
//			System.out.println("myImage is null!");
//		}
		
		int properXCoord = x - myDesiredWidth / 2;
		int properYCoord = y - myDesiredHeight / 2;
		
//		Color c = g.getColor();
//		g.setColor(Color.green);
//		g.fillRect(properXCoord, properYCoord, myDesiredWidth, myDesiredHeight);
//		g.setColor(c);
		
		g.drawImage(myImage, properXCoord, properYCoord, myDesiredWidth, myDesiredHeight, myObserver);
		
//		System.out.println("<><>DELME properXCoord: " + properXCoord + ", properYCoord: " + properYCoord + ", myDesiredWidth: " + myDesiredWidth + ", myDesiredHeight: " + myDesiredHeight);
		
		
	}
	
	
	
	public void drawObjectFromUpperLeftCorner(Graphics g, int x, int y) {
		
//		if(myImage == null) {
//			System.out.println("myImage is null!");
//		}
		
		g.drawImage(myImage, x, y, myDesiredWidth, myDesiredHeight, myObserver);
		
		
	}


	public String getMessage() {
		return message;
	}


	public void setMessage(String message) {
		this.message = message;
	}
	
	public CustomImageData[] retrieveSetOfScaling(int xScale, int yScale) {
		
		CustomImageData returnValue[] = new CustomImageData[11];
		
		for(int i = 0; i <= 10; i++) {
			
			returnValue[i] = new CustomImageData(
					this.getImage(),
					(this.getDesiredWidth() + (i * xScale)) > 0 ? (this.getDesiredWidth() + (i * xScale)) : 0,
					(this.getDesiredHeight() + (i * yScale)) > 0 ? this.getDesiredHeight() + (i * yScale) : 0,
					this.myTransparentColor,
					this.getObserver()
					);
			
			returnValue[i].setMessage("this is faded item number " + i);
			
		}
		
		
		return returnValue;
		
	}
	
	public CustomImageData[] retrieveSetOfRotating(double theta) {
		
		CustomImageData returnValue[] = new CustomImageData[11];
		
		GraphicsEnvironment gm = GraphicsEnvironment.getLocalGraphicsEnvironment();
		
		GraphicsConfiguration gc = gm.getDefaultScreenDevice().getDefaultConfiguration();
		
		BufferedImage imageArray[] = new BufferedImage[11];
		
		Graphics2D g = null;
		
		AffineTransform orig = null;
		AffineTransform rotation = null;
		
		for(int i = 0; i <= 10; i++) {
			
			imageArray[i] = gc.createCompatibleImage(this.getDesiredWidth(), this.getDesiredHeight());
			g = imageArray[i].createGraphics();
			orig = g.getTransform();
			
			rotation = new AffineTransform();
			rotation.rotate(theta * i / 10.0, this.getImage().getWidth(null) / 2, this.getImage().getHeight(null)/ 2);
			
			g.setTransform(rotation);
			
			g.drawImage(this.getImage(), 0, 0, null);
			
			g.setTransform(orig);
			g.dispose();
			
			
			
			
			returnValue[i] = new CustomImageData(
					imageArray[i],
					this.getDesiredWidth(),
					this.getDesiredHeight(),
					this.myTransparentColor,
					this.getObserver()
					);
			
			returnValue[i].setMessage("this is rotated item number " + i);
			
		}
		
		
		return returnValue;
		
	}
	
	public static CustomImageData[] applyChangesToGivenArray(CustomImageData [] origArray, boolean fade, int xScale, int yScale) {
		
		CustomImageData returnValue[] = new CustomImageData[11];
		
		Color adjustedTransparentColor = null;
		
		for(int i = 0; i < 11; i++) {
			
			adjustedTransparentColor = new Color(origArray[i].getTransparentColor().getRed(),
					                             origArray[i].getTransparentColor().getGreen(),
					                             origArray[i].getTransparentColor().getBlue(),
					                             origArray[i].getTransparentColor().getAlpha() * (10 - i) / 10);
			
			returnValue[i] = new CustomImageData(
					fade ? makeImageMoreTransparentOfTen(origArray[i].getImage(),10 - i) : origArray[i].getImage(),
					(origArray[i].getDesiredWidth() + (i * xScale)) > 0 ? (origArray[i].getDesiredWidth() + (i * xScale)) : 0,
					(origArray[i].getDesiredHeight() + (i * yScale)) > 0 ? (origArray[i].getDesiredHeight() + (i * yScale)) : 0,
					fade ? adjustedTransparentColor : origArray[i].getTransparentColor(),
					origArray[i].getObserver()
					);
			
		}
		
		
		
		return returnValue;
		
	}


	public Color getTransparentColor() {
		return myTransparentColor;
	}
	
	public boolean wasInitialized() {
		return hasBeenInitialized;
	}
	
	public void setInitialized() {
		hasBeenInitialized = true;
	}
	
	
	public void primeImage(Graphics g, int panelWidth, int panelHeight) {
		this.drawObject(g, -panelWidth - this.myDesiredWidth, -panelHeight - this.myDesiredHeight);
	}
	
	

	public static Color translateFileInStringToColor(String inputter) {
		try {
			String split[] = inputter.split(":");
			
			int red = Integer.parseInt(split[0]);
			int green = Integer.parseInt(split[1]);
			int blue = Integer.parseInt(split[2]);
			
			return new Color(red, green, blue);
		}catch(NumberFormatException nfe) {
			return null;
		} catch(IndexOutOfBoundsException ioobe) {
			return null;
		}
	}
	
}
